#ifndef MATERIAL_H
#define MATERIAL_H

#include "rwcommon.h"
#include "rtimport.h"

typedef struct
{
    int         materialMap;
    RpMaterial  *rwMaterial;
    int         rtImportMaterial;
} MaterialMap;

RpMaterial          *MayaShadingGroup2RpMaterial(int shape, int group, bool verbose, bool *textureNameWarning);
RwMatrix            *getUVTransformMatrix(int shape, int group);
char                *getTexFileNodeName(char *mtlName, char *texType);
char                *getTexFilename(char *filenodeName);
RwTextureFilterMode getMtlFilterMode(char *mtlName);
bool                CompareMayaShadingGroups(int id0, int id1);
bool                MayaShadingGroupIsTextured(int shapeIndex, int group);
void                CheckTextureMask(RpMaterial *material, int shape, int group);
MaterialMap         *BuildMaterialMap(RtWorldImport *importWorld, bool verbose, bool *textureNameWarning);
void                DestroyMaterialMap(MaterialMap *materialMap);
MObject             fileTextureCallBack(MObject object, void *pData);

#endif /* MATERIAL_H */